/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.util;

import java.awt.Component;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.ScriptContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.jythonsupport.ui.DataMashUp;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class PlotDataMashupResolver
implements DataMashUp.Resolver {
    private static Logger logger = LoggerManager.getLogger((String)"autoplot.gui");
    final DataMashUp dm;

    public PlotDataMashupResolver(DataMashUp dm) {
        this.dm = dm;
    }

    public QDataSet getDataSet(String uri) {
        try {
            return DataSetURI.getDataSource((String)uri).getDataSet((ProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            logger.log(Level.INFO, null, ex);
            return null;
        }
    }

    public BufferedImage getImage(QDataSet qds) {
        return AutoplotUtil.createImage(qds, 120, 60);
    }

    public void interactivePlot(QDataSet qds) {
        Window w = SwingUtilities.getWindowAncestor((Component)this.dm);
        ApplicationModel model = ScriptContext.newDialogWindow(w, qds.toString());
        model.setDataSet(qds);
    }
}

